package cn.com.duiba.goods.common.enums.goods;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 逻辑删除枚举
 * Created by guoyanfei .
 * 2022/11/7 .
 */
public enum GoodsAuditState implements BaseEnum {

    PASSED(1, "审核通过"),
    REJECTED(2, "审核拒绝");

    private final int code;

    private final String desc;

    GoodsAuditState(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static GoodsAuditState getByCode(int code) {
        for (GoodsAuditState it : GoodsAuditState.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "GoodsAuditState");
    }

}
