package cn.com.duiba.goods.common.enums.goods;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 商品发票类型
 * Created by guoyanfei .
 * 2023/1/10 .
 */
public enum InvoiceType implements BaseEnum {

    NORMAL(1, "普票"),
    PRO(2, "专票");

    private final int code;

    private final String desc;

    InvoiceType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static InvoiceType getByCode(int code) {
        for (InvoiceType it : InvoiceType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "InvoiceType");
    }

}
