package cn.com.duiba.goods.common.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2023/8/9 10:36
 */
@Getter
@AllArgsConstructor
public enum VirtualNotifyTypeEnum {

    NOT_NOTIFY(1, "不需要通知"),

    NOTIFY_ALL(2, "所有状态回调"),

    NOTIFY_SUCCESS(3, "仅通知成功状态的"),

    NOTIFY_SUCCESS_AND_FAIL(4, "仅通知成功或失败状态的"),

    ;
    private final int type;

    private final String desc;

    private static final Map<Integer, VirtualNotifyTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(VirtualNotifyTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static VirtualNotifyTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
