package cn.com.duiba.goods.common.enums.order;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 订单售后单表的 refundType 字段枚举
 * Created by guoyanfei .
 * 2022/12/14 .
 */
public enum RefundType implements BaseEnum {

    ONLY_REFUND(1, "仅退款"),
    RETURN_AND_REFUND(2, "退货退款");

    private final int code;

    private final String desc;

    RefundType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static RefundType getByCode(int code) {
        for (RefundType it : RefundType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "RefundType");
    }
}
