package cn.com.duiba.goods.common.enums.stock;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 库存流水的 actionType 字段枚举
 * Created by guoyanfei .
 * 2022/11/7 .
 */
public enum WaterBillActionType implements BaseEnum {

    MANUAL_INCR(1, "手动新增（创建/编辑）"),
    ROLLBACK_PRE_ALLOCATED(2, "预分配回滚"),
    ROLLBACK_WITH_ORDER(3, "退货入库"),
    MANUAL_DECR(4, "手动减少（编辑）"),
    PRE_ALLOCATED(5, "库存预分配"),
    CHANGE_WITH_ORDER(6, "客户下单"),
    MAKE_INVALID(7, "失效扣除");

    private final int code;

    private final String desc;

    WaterBillActionType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static WaterBillActionType getByCode(int code) {
        for (WaterBillActionType it : WaterBillActionType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "WaterBillActionType");
    }
}
