package cn.com.duiba.goods.common.utils;

import java.util.concurrent.Callable;

/**
 * 批量任务的每个子任务
 * Created by guoyanfei .
 * 2022/12/27 .
 */
public abstract class BatchPerTask<T, R> implements Callable<R> {

    private final T data;

    public BatchPerTask(T data) {
        this.data = data;
    }

    @Override
    public R call() throws Exception {
        return doCall(data);
    }

    public abstract R doCall(T data);
}
