package cn.com.duiba.goods.common.utils;

import java.math.BigDecimal;

public final class GoodsMathUtils {

    private GoodsMathUtils() {
    }

    public static BigDecimal divide2(String a, String b) {
        return divide(a, b, 2);
    }

    public static BigDecimal divide4(String a, String b) {
        return divide(a, b, 4);
    }

    public static BigDecimal multiply100(String a) {
        return new BigDecimal(a).multiply(new BigDecimal(100));
    }

    public static BigDecimal percent(String a, String b) {
        return new BigDecimal(a).multiply(new BigDecimal(100)).divide(new BigDecimal(b), 2, BigDecimal.ROUND_HALF_UP);
    }

    private static BigDecimal divide(String a, String b, int scale) {
        return new BigDecimal(a).divide(new BigDecimal(b), scale, BigDecimal.ROUND_HALF_UP);
    }
}
