package cn.com.duiba.goods.common.enums.stock;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 库存流水的 bizType 字段枚举
 * Created by guoyanfei .
 * 2022/11/7 .
 */
public enum WaterBillBizType implements BaseEnum {

    STANDARD_ORDER(1, "标准下单");

    private final int code;

    private final String desc;

    WaterBillBizType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static WaterBillBizType getByCode(int code) {
        for (WaterBillBizType it : WaterBillBizType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "WaterBillBizType");
    }
}
