package cn.com.duiba.goods.common.enums.stock;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 库存流水的 changeType 字段枚举
 * Created by guoyanfei .
 * 2022/11/7 .
 */
public enum WaterBillChangeType implements BaseEnum {

    INCR(1, "+"),
    DECR(2, "-");

    private final int code;

    private final String desc;

    WaterBillChangeType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static WaterBillChangeType getByCode(int code) {
        for (WaterBillChangeType it : WaterBillChangeType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "WaterBillChangeType");
    }
}
