/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.common.configuration;

import cn.com.duiba.goods.common.configuration.PrefixHandler;
import cn.com.duiba.wolf.entity.Pair;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ControllerPrefixBeanPostProcessor
implements SpecifiedBeanPostProcessor<RequestMappingHandlerMapping> {
    @Resource
    private Set<PrefixHandler> prefixHandlers;

    public Class<RequestMappingHandlerMapping> getBeanType() {
        return RequestMappingHandlerMapping.class;
    }

    public Object postProcessBeforeInitialization(RequestMappingHandlerMapping bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(RequestMappingHandlerMapping bean, String beanName) throws BeansException {
        if (CollectionUtils.isEmpty(this.prefixHandlers)) {
            return bean;
        }
        Map methodMap = bean.getHandlerMethods();
        ArrayListMultimap reregisterMap = ArrayListMultimap.create();
        for (Map.Entry m : methodMap.entrySet()) {
            RequestMappingInfo info = (RequestMappingInfo)m.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)m.getValue();
            for (PrefixHandler handler : this.prefixHandlers) {
                if (!handler.match(handlerMethod.getBeanType())) continue;
                reregisterMap.put((Object)handler, (Object)Pair.from((Object)info, (Object)handlerMethod));
            }
        }
        if (reregisterMap.isEmpty()) {
            return bean;
        }
        for (PrefixHandler handler : reregisterMap.keySet()) {
            List pairs = (List)reregisterMap.get((Object)handler);
            for (Pair it : pairs) {
                RequestMappingInfo info = (RequestMappingInfo)it.getKey();
                HandlerMethod handlerMethod = (HandlerMethod)it.getValue();
                bean.unregisterMapping((Object)info);
                bean.registerMapping(handler.combineRequestMappingInfo(info), handlerMethod.getBean(), handlerMethod.getMethod());
            }
        }
        return bean;
    }

    public int getOrder() {
        return 0;
    }
}

