/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.common.dto;

import cn.com.duiba.goods.common.enums.goods.AccountType;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AccountInfo
implements Serializable {
    private static final long serialVersionUID = -458034431842518256L;
    private Integer type;
    private String value;

    public AccountInfo() {
    }

    public AccountInfo(Integer type, String value) {
        this.type = type;
        this.value = value;
    }

    public String toString() {
        return AccountType.getByCode(this.type).desc() + ":" + this.value;
    }

    public static List<AccountInfo> parseToList(String accountInfo) {
        if (StringUtils.isBlank((CharSequence)accountInfo)) {
            return Collections.emptyList();
        }
        ArrayList<AccountInfo> list = new ArrayList<AccountInfo>();
        JSONArray accountArray = JSONArray.parseArray((String)accountInfo);
        accountArray.stream().forEach(account -> {
            int type = ((JSONObject)account).getIntValue("type");
            String value = ((JSONObject)account).getString("value");
            list.add(new AccountInfo(AccountType.getByCode(type).code(), value));
        });
        return list;
    }

    public static Map<Integer, AccountInfo> parseToMap(String accountInfo) {
        if (StringUtils.isBlank((CharSequence)accountInfo)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, AccountInfo> map = new HashMap<Integer, AccountInfo>();
        JSONArray accountArray = JSONArray.parseArray((String)accountInfo);
        accountArray.stream().forEach(account -> {
            int type = ((JSONObject)account).getIntValue("type");
            String value = ((JSONObject)account).getString("value");
            map.put(type, new AccountInfo(AccountType.getByCode(type).code(), value));
        });
        return map;
    }

    public static String parseToString(String accountInfo) {
        if (StringUtils.isBlank((CharSequence)accountInfo)) {
            return "";
        }
        List<AccountInfo> list = AccountInfo.parseToList(accountInfo);
        return Joiner.on((String)", ").join(list);
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

