/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.common.utils;

import cn.com.duiba.goods.common.utils.BatchCallable;
import cn.com.duiba.goods.common.utils.BatchPerTask;
import cn.com.duiba.goods.common.utils.PagerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public final class BatchEngine<T, R> {
    public static <T, R> List<R> submit(List<T> todoList, int perBatchSize, ExecutorService executorService, final BatchCallable<T, R> callable) {
        int pageCount = PagerUtils.pageCount(perBatchSize, todoList.size());
        ArrayList rList = new ArrayList(todoList.size());
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            int fromIndex = pageIndex * perBatchSize;
            int toIndex = Math.min((pageIndex + 1) * perBatchSize, todoList.size());
            List<T> temp = todoList.subList(fromIndex, toIndex);
            ArrayList futureList = new ArrayList(temp.size());
            for (T t : temp) {
                Future future = executorService.submit(new BatchPerTask<T, R>(t){

                    @Override
                    public R doCall(T data) {
                        return callable.call(data);
                    }
                });
                futureList.add(future);
            }
            try {
                for (Future future : futureList) {
                    rList.add(future.get());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            if (Thread.currentThread().isInterrupted()) break;
        }
        return rList;
    }

    public static <T> void execute(List<T> todoList, int perBatchSize, ExecutorService executorService, final BatchCallable<T, Void> callable) {
        int pageCount = PagerUtils.pageCount(perBatchSize, todoList.size());
        for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
            int fromIndex = pageIndex * perBatchSize;
            int toIndex = Math.min((pageIndex + 1) * perBatchSize, todoList.size());
            List<T> temp = todoList.subList(fromIndex, toIndex);
            ArrayList<Future<Void>> futureList = new ArrayList<Future<Void>>(temp.size());
            for (T t : temp) {
                Future<Void> future = executorService.submit(new BatchPerTask<T, Void>(t){

                    @Override
                    public Void doCall(T data) {
                        return (Void)callable.call(data);
                    }
                });
                futureList.add(future);
            }
            try {
                for (Future future : futureList) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            if (Thread.currentThread().isInterrupted()) break;
        }
    }
}

