/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.common.enums.stock;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

public enum StockSourceType implements BaseEnum
{
    SHARED_SKU(1, "\u5171\u4eabSKU\u5e93\u5b58"),
    PRE_ALLOCATED_SKU(2, "\u9884\u5206\u914dSKU\u5e93\u5b58");

    private final int code;
    private final String desc;

    private StockSourceType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public String desc() {
        return this.desc;
    }

    public static StockSourceType getByCode(int code) {
        for (StockSourceType it : StockSourceType.values()) {
            if (it.code() != code) continue;
            return it;
        }
        throw new EnumNotFoundException(code, "StockSourceType");
    }
}

