/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.inner.api.autoconfig.excel;

import cn.com.duiba.goods.common.exception.IllegalParamException;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.data.ReadCellData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonAnalysisEventListener<T>
extends AnalysisEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(CommonAnalysisEventListener.class);
    private Class<T> clazz;
    private List<T> dataList = new ArrayList<T>();

    public CommonAnalysisEventListener(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void invoke(T data, AnalysisContext context) {
        this.dataList.add(data);
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
        Field[] fields = this.clazz.getDeclaredFields();
        int size = 0;
        for (Field field : fields) {
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty == null) continue;
            int fieldHeadIndex = excelProperty.index();
            String fieldHeadName = excelProperty.value()[0];
            ReadCellData<?> currentHead = headMap.get(fieldHeadIndex);
            if (currentHead == null) {
                throw new IllegalParamException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef1");
            }
            String currentHeadName = currentHead.getStringValue();
            if (!StringUtils.equals((CharSequence)fieldHeadName, (CharSequence)currentHeadName)) {
                log.warn("\u4e0a\u4f20\u7684excel\u6587\u4ef6\u9519\u8bef, fieldHeadName={}, currentHeadName={}", (Object)fieldHeadName, (Object)currentHeadName);
                throw new IllegalParamException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef2");
            }
            ++size;
        }
        if (size != headMap.size()) {
            log.warn("\u4e0a\u4f20\u7684excel\u6587\u4ef6\u9519\u8bef, \u671f\u671b\u5217\u6570={}, \u5b9e\u9645\u5217\u6570={}", (Object)size, (Object)headMap.size());
            throw new IllegalParamException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef3");
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }
}

