/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.inner.api.autoconfig.excel;

import cn.com.duiba.goods.common.dto.ScrollingPageRequest;
import cn.com.duiba.goods.common.enums.ScrollingType;
import cn.com.duiba.goods.inner.api.autoconfig.excel.CommonAnalysisEventListener;
import cn.com.duiba.goods.inner.api.autoconfig.excel.ExcelPageQuery;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class EasyExcelComponent {
    private static final int SHEET_MAX = 1048575;

    public <T> List<T> readExcel(InputStream inputStream, Class<T> importParamClass) {
        CommonAnalysisEventListener<T> listener = new CommonAnalysisEventListener<T>(importParamClass);
        EasyExcelFactory.read((InputStream)inputStream, importParamClass, listener).sheet().doRead();
        List<T> dataList = listener.getDataList();
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        return dataList;
    }

    public <T> void writeExcel(List<T> dataList, OutputStream outputStream, Class<T> outputParamClass) {
        EasyExcelFactory.write((OutputStream)outputStream, outputParamClass).autoCloseStream(Boolean.valueOf(true)).sheet().doWrite(dataList);
    }

    public <P extends ScrollingPageRequest, R> void pageWriteExcel(OutputStream outputStream, ExcelPageQuery<P, R> query, P param) {
        int dataSize;
        Class<R> headerClass = query.getHeaderClass();
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        HorizontalCellStyleStrategy contentStyleStrategy = new HorizontalCellStyleStrategy();
        contentStyleStrategy.setContentWriteCellStyleList(Arrays.asList(contentWriteCellStyle));
        ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)new ExcelWriterBuilder().autoCloseStream(Boolean.valueOf(true)).automaticMergeHead(Boolean.valueOf(true))).excelType(ExcelTypeEnum.XLSX).file(outputStream).head(headerClass)).registerWriteHandler((WriteHandler)contentStyleStrategy)).build();
        int sheetNum = 1;
        WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)("sheet" + sheetNum)).head(headerClass)).build();
        int currentSheetTotal = 1;
        int scrollingType = param.getScrollingType() != null ? param.getScrollingType().intValue() : ScrollingType.DESC.code();
        param.setScrollingType(Integer.valueOf(scrollingType));
        do {
            Pair<List<R>, Long> dataPair;
            List dataList;
            if ((currentSheetTotal += (dataSize = (dataList = (List)(dataPair = query.findPage(param)).getLeft()).size())) >= 1048575) {
                currentSheetTotal = 1 + dataSize;
                writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)("sheet" + ++sheetNum)).head(headerClass)).build();
            }
            excelWriter.write((Collection)dataList, writeSheet);
            param.setBoundaryValue((Long)dataPair.getRight());
        } while (dataSize >= param.getPageSize());
        excelWriter.finish();
    }
}

