package cn.com.duiba.goods.inner.api.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 商品规格区封装类
 */
public class AttrValuesDTO implements Serializable {

    private static final long serialVersionUID = -8841961221911109815L;
    
    /**
     * 属性key的id，如果是自定义，那么为0
     */
    private Long key;

    /**
     * 属性key的别名，如：内存
     */
    private String keyAlias;

    /**
     * 是否有图片（【规格图】是否打勾）
     */
    private Boolean hasImg = false;

    /**
     * 属性值list
     */
    private List<Value> vals = new ArrayList<>();

    public void addValue(Value value) {
        vals.add(value);
    }

    public static class Value {

        /**
         * 属性val的id，如果是自定义，那么为0
         */
        private Long val;

        /**
         * 属性val的别名，如：128G
         */
        private String valAlias;

        /**
         * SKU的批量设置图片
         */
        private String img;

        public Long getVal() {
            return val;
        }

        public void setVal(Long val) {
            this.val = val;
        }

        public String getValAlias() {
            return valAlias;
        }

        public void setValAlias(String valAlias) {
            this.valAlias = valAlias;
        }

        public String getImg() {
            return img;
        }

        public void setImg(String img) {
            this.img = img;
        }
    }

    public Boolean getHasImg() {
        return hasImg;
    }

    public void setHasImg(Boolean hasImg) {
        this.hasImg = hasImg;
    }

    public Long getKey() {
        return key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    public String getKeyAlias() {
        return keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public List<Value> getVals() {
        return vals;
    }

    public void setVals(List<Value> vals) {
        this.vals = vals;
    }
}
