package cn.com.duiba.goods.inner.api.dto;

import java.io.Serializable;

/**
 * 商品简述
 * Created by guoyanfei .
 * 2022/11/21 .
 */
public class SpuOverviewDTO implements Serializable {

    private static final long serialVersionUID = -4268474011060028287L;

    /**
     * SPU id（不作为展示用）
     */
    private String id;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 类目id
     */
    private Long categoryId;

    /**
     * 商品ID（用于展示）
     */
    private String spuCode;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 品牌名
     */
    private String brandName;

    /**
     * 商品类型，1实物，2虚拟
     * {@code @cn.com.duiba.goods.common.enums.goods.SpuType}
     */
    private Integer spuType;

    /**
     * 商品状态，1待提审，2审核中，3已入库
     * {@code @cn.com.duiba.goods.common.enums.goods.SpuState}
     */
    private Integer spuState;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getSpuCode() {
        return spuCode;
    }

    public void setSpuCode(String spuCode) {
        this.spuCode = spuCode;
    }

    public String getSpuName() {
        return spuName;
    }

    public void setSpuName(String spuName) {
        this.spuName = spuName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Integer getSpuType() {
        return spuType;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public Integer getSpuState() {
        return spuState;
    }

    public void setSpuState(Integer spuState) {
        this.spuState = spuState;
    }
}
