package cn.com.duiba.goods.inner.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.inner.api.dto.*;
import cn.com.duiba.wolf.entity.PageResponse;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 商品相关RPC接口
 * Created by guoyanfei .
 * 2022/11/18 .
 */
@Validated
@AdvancedFeignClient
public interface RemoteGoodsService {

    /**
     * 查询分页列表
     *
     * @param search 查询参数
     * @return 分页展示信息
     */
    PageResponse<SpuListDTO> page(@Valid SpuListSearchDTO search);

    /**
     * 查详情
     *
     * @param id spu id
     * @return 商品详情
     */
    SpuDetailDTO getDetail(@NotNull(message = "【SPU id】不能为null") Long id) throws BizException;

    /**
     * 查简述
     *
     * @param id
     * @return
     * @throws BizException
     */
    SpuOverviewDTO getOverview(@NotNull(message = "【SPU id】不能为null") Long id) throws BizException;

    /**
     * 保存
     *
     * @param saveDto
     * @return spuid
     */
    Long save(@Valid SpuSaveDTO saveDto) throws BizException;

    /**
     * 提交审核
     *
     * @param id spu id
     * @throws BizException
     */
    void auditSubmit(@NotNull(message = "【SPU id】不能为null") Long id) throws BizException;

    /**
     * 商品审核通过
     *
     * @param passDTO
     * @throws BizException
     */
    void auditPass(@Valid SpuAuditPassDTO passDTO) throws BizException;

    /**
     * 商品审核拒绝
     *
     * @param rejectDTO
     * @throws BizException
     */
    void auditReject(@Valid SpuAuditRejectDTO rejectDTO) throws BizException;

    /**
     * 获取商品编辑页面的商品规格区数据
     *
     * @param id
     * @return
     * @throws BizException
     */
    List<AttrValuesDTO> getAttrValues(@NotNull(message = "【SPU id】不能为null") Long id) throws BizException;

    /**
     * 标记删除商品
     *
     * @param id
     */
    void flagDelete(@NotNull(message = "【SPU id】不能为null") Long id);

    /**
     * 单个SPU下面每个SKU的库存DTO
     *
     * @param id
     * @return
     */
    List<SpuStockDTO> listStock(@NotNull(message = "【SPU id】不能为null") Long id) throws BizException;
}
