package cn.com.duiba.goods.inner.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.inner.api.dto.SupplierDTO;
import cn.com.duiba.wolf.entity.PageRequest;
import cn.com.duiba.wolf.entity.PageResponse;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 供应商相关RPC接口
 * Created by guoyanfei .
 * 2022/10/20 .
 */
@Validated
@AdvancedFeignClient
public interface RemoteSupplierService {

    /**
     * 根据【供应商id】获取供应商，包含禁用
     *
     * @param id 供应商id
     * @return 供应商信息(不包含密码)
     */
    SupplierDTO get(@NotNull(message = "【供应商id】不能为null") Long id) throws BizException;

    /**
     * 根据账户获取供应商信息
     *
     * @param account 账户信息
     * @return 供应商信息
     */
    SupplierDTO getByAccount(@NotBlank(message = "【供应商账号】不能为null") String account) throws BizException;

    /**
     * 根据【query】模糊查询供应商，包含禁用
     *
     * @param query 关键字
     * @return 供应商信息(不包含密码)
     */
    List<SupplierDTO> list(String query);

    /**
     * 查询供应商分页list
     *
     * @param request 分页参数
     * @return 供应商信息分页结果
     */
    PageResponse<SupplierDTO> page(PageRequest request);

    /**
     * 保存供应商信息
     *
     * @param supplier 供应商信息
     * @return 返回变更的供应商id
     */
    Long save(@Valid SupplierDTO supplier) throws BizException;

    /**
     * 根据【供应商id】获取密码
     *
     * @param id 供应商id
     * @return 供应商密码
     */
    String getPasswd(@NotNull(message = "【供应商id】不能为null") Long id) throws BizException;

    /**
     * 根据【供应商id】重置密码
     *
     * @param id 供应商id
     */
    void resetPasswd(@NotNull(message = "【供应商id】不能为null") Long id) throws BizException;

}
