package cn.com.duiba.goods.inner.api.dto;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 商品审核通过参数DTO
 * Created by guoyanfei .
 * 2022/11/15 .
 */
public class SpuAuditPassDTO implements Serializable {

    private static final long serialVersionUID = -3397423483968111089L;

    /**
     * SPU id
     */
    @NotNull(message = "【SPU id】不能为空")
    private Long id;

    /**
     * 客户id（所属业务id）
     */
    @NotNull(message = "【所属业务】不能为空")
    private Long customerId;

    /**
     * 审核人
     */
    @NotNull(message = "【审核人adminId】不能为空")
    private Long adminId;

    /**
     * SKU 变更信息
     */
    @NotNull(message = "【SKU】不能为空")
    private List<SkuAuditPassDTO> skus;


    public static class SkuAuditPassDTO implements Serializable{

        private static final long serialVersionUID = -7956793097541204701L;

        /**
         * SKU id
         */
        @NotNull(message = "【SKU id】不能为空")
        private Long id;

        /**
         * 建议售价
         */
        @NotNull(message = "【建议售价】不能为空")
        private Integer sellPrice;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Integer getSellPrice() {
            return sellPrice;
        }

        public void setSellPrice(Integer sellPrice) {
            this.sellPrice = sellPrice;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getAdminId() {
        return adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public List<SkuAuditPassDTO> getSkus() {
        return skus;
    }

    public void setSkus(List<SkuAuditPassDTO> skus) {
        this.skus = skus;
    }
}
