package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.goods.common.dto.AttrValue;

import java.io.Serializable;
import java.util.List;

/**
 * 商品详情
 * Created by guoyanfei .
 * 2022/11/21 .
 */
public class SpuDetailDTO implements Serializable {

    private static final long serialVersionUID = -1743580431966798447L;

    /**
     * SPU id（不作为展示用）
     */
    private Long id;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 类目id
     */
    private Long categoryId;

    /**
     * 商品ID（用于展示）
     */
    private String spuCode;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 品牌名
     */
    private String brandName;

    /**
     * 商品类型，1实物，2虚拟
     * {@code @cn.com.duiba.goods.common.enums.goods.SpuType}
     */
    private Integer spuType;

    /**
     * 商品主图链接，多张图用英文 逗号 分割
     */
    private String mainImgs;

    /**
     * 商品详情图链接，多张图用英文 逗号 分割
     */
    private String detailImgs;

    /**
     * 税率，比如16%，那么存储1600
     */
    private Integer taxRate;

    /**
     * 商品描述
     */
    private String spuDesc;

    /**
     * 商品状态，1待提审，2审核中，3已入库
     * {@code @cn.com.duiba.goods.common.enums.goods.SpuState}
     */
    private Integer spuState;

    // ====== 下方字段需要关联其他表获取 ======

    /**
     * 商品类目
     */
    private String categoryName;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 客户id（所属业务id），审核完成之前该字段为null
     */
    private Long customerId;

    /**
     * 客户名称（所属业务名称），审核完成之前该字段为null
     */
    private String customerName;

    /**
     * sku列表
     */
    private List<SkuDetail> skus;

    /**
     * 商品物流信息
     */
    private GoodsExpress goodsExpress;

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public GoodsExpress getGoodsExpress() {
        return goodsExpress;
    }

    public void setGoodsExpress(GoodsExpress goodsExpress) {
        this.goodsExpress = goodsExpress;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getSpuCode() {
        return spuCode;
    }

    public void setSpuCode(String spuCode) {
        this.spuCode = spuCode;
    }

    public String getSpuName() {
        return spuName;
    }

    public void setSpuName(String spuName) {
        this.spuName = spuName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Integer getSpuType() {
        return spuType;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public String getMainImgs() {
        return mainImgs;
    }

    public void setMainImgs(String mainImgs) {
        this.mainImgs = mainImgs;
    }

    public String getDetailImgs() {
        return detailImgs;
    }

    public void setDetailImgs(String detailImgs) {
        this.detailImgs = detailImgs;
    }

    public Integer getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
    }

    public String getSpuDesc() {
        return spuDesc;
    }

    public void setSpuDesc(String spuDesc) {
        this.spuDesc = spuDesc;
    }

    public Integer getSpuState() {
        return spuState;
    }

    public void setSpuState(Integer spuState) {
        this.spuState = spuState;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public List<SkuDetail> getSkus() {
        return skus;
    }

    public void setSkus(List<SkuDetail> skus) {
        this.skus = skus;
    }

    /**
     * 商品详情(SKU)展示实体
     */
    public static class SkuDetail implements Serializable {

        private static final long serialVersionUID = 4257048853574318770L;

        /**
         * SKU id
         */
        public Long id;

        /**
         * 供应商的规格编码（用于展示）
         */
        private String supplierSkuCode;

        /**
         * SKU图，这个图是详情展示图，逻辑为 SKU图 -> 批量SKU图 -> 商品主图，编辑页面该字段无用
         */
        private String showSkuImg;

        /**
         * 优先级最高的SKU图，是针对单个SKU单独设置的
         */
        private String skuImg;

        /**
         * 规格配置
         */
        private List<AttrValue> attrValueList;

        /**
         * 兑吧的sku编码，全局唯一（暂时不用于展示）
         */
        private String skuCode;

        /**
         * 供货价，单位分，比如1元，数据存为100
         */
        private Integer supplyPrice;

        /**
         * 指导价，划线价，单位分，比如1元，数据存为100
         */
        private Integer marketPrice;

        /**
         * 建议售价，平台卖价，单位分，比如1元，数据存为100
         */
        private Integer sellPrice;

        /**
         * 库存余量
         */
        private Integer remaining;

        public Integer getSellPrice() {
            return sellPrice;
        }

        public void setSellPrice(Integer sellPrice) {
            this.sellPrice = sellPrice;
        }

        public String getSkuImg() {
            return skuImg;
        }

        public void setSkuImg(String skuImg) {
            this.skuImg = skuImg;
        }

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getSupplierSkuCode() {
            return supplierSkuCode;
        }

        public void setSupplierSkuCode(String supplierSkuCode) {
            this.supplierSkuCode = supplierSkuCode;
        }

        public String getShowSkuImg() {
            return showSkuImg;
        }

        public void setShowSkuImg(String showSkuImg) {
            this.showSkuImg = showSkuImg;
        }

        public List<AttrValue> getAttrValueList() {
            return attrValueList;
        }

        public void setAttrValueList(List<AttrValue> attrValueList) {
            this.attrValueList = attrValueList;
        }

        public String getSkuCode() {
            return skuCode;
        }

        public void setSkuCode(String skuCode) {
            this.skuCode = skuCode;
        }

        public Integer getSupplyPrice() {
            return supplyPrice;
        }

        public void setSupplyPrice(Integer supplyPrice) {
            this.supplyPrice = supplyPrice;
        }

        public Integer getMarketPrice() {
            return marketPrice;
        }

        public void setMarketPrice(Integer marketPrice) {
            this.marketPrice = marketPrice;
        }

        public Integer getRemaining() {
            return remaining;
        }

        public void setRemaining(Integer remaining) {
            this.remaining = remaining;
        }
    }

    /**
     * 商品物流信息
     */
    public static class GoodsExpress implements Serializable {

        private static final long serialVersionUID = -1673583810079655516L;

        /**
         * 发货地
         */
        private String deliveryPlace;

        /**
         * 发货物流公司
         */
        private String deliveryExpressCompany;

        /**
         * 七天无理由，1支持，0不支持
         * {@code @cn.com.duiba.goods.common.enums.goods.SevenDaysNoReason}
         */
        private Integer sevenDaysNoReason;

        /**
         * 退换货地址以及联系方式
         */
        private String details;

        public String getDeliveryPlace() {
            return deliveryPlace;
        }

        public void setDeliveryPlace(String deliveryPlace) {
            this.deliveryPlace = deliveryPlace;
        }

        public String getDeliveryExpressCompany() {
            return deliveryExpressCompany;
        }

        public void setDeliveryExpressCompany(String deliveryExpressCompany) {
            this.deliveryExpressCompany = deliveryExpressCompany;
        }

        public Integer getSevenDaysNoReason() {
            return sevenDaysNoReason;
        }

        public void setSevenDaysNoReason(Integer sevenDaysNoReason) {
            this.sevenDaysNoReason = sevenDaysNoReason;
        }

        public String getDetails() {
            return details;
        }

        public void setDetails(String details) {
            this.details = details;
        }
    }

}
