package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.wolf.entity.PageRequest;

import javax.validation.constraints.Size;
import java.util.List;

/**
 * 商品列表页查询参数dto
 * Created by guoyanfei .
 * 2022/11/18 .
 */
public class SpuListSearchDTO extends PageRequest {

    private static final long serialVersionUID = 3600319139750062552L;

    /**
     * 商品ID
     */
    @Size(max = 15, message = "【商品ID】不能大于15位")
    private String spuCode;

    /**
     * 商品名称
     */
    @Size(max = 40, message = "【商品名称】不能大于40位")
    private String spuNameQueryStr;


    /**
     * 商品类目id
     */
    private Long categoryId;

    /**
     * 商品状态list，查询这几个状态内的数据
     * {@code @cn.com.duiba.goods.common.enums.goods.SpuState}
     */
    private List<Integer> spuStateList;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 最低建议售价，单位分，比如1元，此处数据为100
     */
    private Integer minSellPrice;

    /**
     * 最高建议售价，单位分，比如1元，此处数据为100
     */
    private Integer maxSellPrice;

    /**
     * 客户id（所属业务id），该条件仅用于已入库商品，待审核商品不支持该条件搜索
     */
    private Long customerId;

    public String getSpuCode() {
        return spuCode;
    }

    public void setSpuCode(String spuCode) {
        this.spuCode = spuCode;
    }

    public String getSpuNameQueryStr() {
        return spuNameQueryStr;
    }

    public void setSpuNameQueryStr(String spuNameQueryStr) {
        this.spuNameQueryStr = spuNameQueryStr;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public List<Integer> getSpuStateList() {
        return spuStateList;
    }

    public void setSpuStateList(List<Integer> spuStateList) {
        this.spuStateList = spuStateList;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Integer getMinSellPrice() {
        return minSellPrice;
    }

    public void setMinSellPrice(Integer minSellPrice) {
        this.minSellPrice = minSellPrice;
    }

    public Integer getMaxSellPrice() {
        return maxSellPrice;
    }

    public void setMaxSellPrice(Integer maxSellPrice) {
        this.maxSellPrice = maxSellPrice;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
}
