package cn.com.duiba.goods.inner.api.dto;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * 供应商dto
 * Created by guoyanfei .
 * 2022/11/17 .
 */
public class SupplierDTO implements Serializable {

    private static final long serialVersionUID = 3726489389103178380L;

    /**
     * 自增id
     */
    private Long id;

    /**
     * 供应商名称
     */
    @NotBlank(message = "【供应商名称】不能为空")
    @Size(max = 30, message = "【供应商名称】不能大于30位")
    private String supplierName;

    /**
     * 供应商描述
     */
    @NotBlank(message = "【供应商描述】不能为空")
    @Size(max = 50, message = "【供应商描述】不能大于50位")
    private String supplierDesc;

    /**
     * 联系人姓名
     */
    @NotBlank(message = "【联系人姓名】不能为空")
    @Size(max = 10, message = "【联系人姓名】不能大于10位")
    private String ownerName;

    /**
     * 电话号码，也作为账号
     */
    @NotBlank(message = "【联系人电话】不能为空")
    @Size(min = 11, max = 11, message = "【联系人电话】必须为11位")
    private String ownerTel;

    /**
     * 是否启用，1启用，0禁用
     * {@code @cn.com.duiba.goods.common.enums.EnabledEnum}
     */
    private Integer enabled;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;

    /**
     * 记录最近更新时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierDesc() {
        return supplierDesc;
    }

    public void setSupplierDesc(String supplierDesc) {
        this.supplierDesc = supplierDesc;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerTel() {
        return ownerTel;
    }

    public void setOwnerTel(String ownerTel) {
        this.ownerTel = ownerTel;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
