package cn.com.duiba.goods.inner.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.inner.api.dto.CustomerDTO;
import cn.com.duiba.goods.inner.api.dto.CustomerWithSecretDTO;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 客户相关RPC接口
 * Created by guoyanfei .
 * 2022/11/18 .
 */
@Validated
@AdvancedFeignClient
public interface RemoteCustomerService {

    /**
     * 获取所有启用的客户信息，不包含secret
     *
     * @return 客户信息list
     */
    List<CustomerDTO> listEnabled();

    /**
     * 根据apiKey查询客户信息，包含secret
     *
     * @param apiKey 查询
     * @return 客户信息
     * @throws BizException
     */
    CustomerWithSecretDTO getByApiKey(@NotBlank(message = "【apiKey】不能为null") String apiKey) throws BizException;
}
