/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.goods.common.dto.AttrValue;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.collections4.CollectionUtils;

public class SpuSaveDTO
implements Serializable {
    private static final long serialVersionUID = 6859927092649161591L;
    private Long id;
    @NotNull(message="\u3010\u4f9b\u5e94\u5546id\u3011\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u3010\u4f9b\u5e94\u5546id\u3011\u4e0d\u80fd\u4e3a\u7a7a") Long supplierId;
    @NotBlank(message="\u3010\u5546\u54c1\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(max=40, message="\u3010\u5546\u54c1\u540d\u79f0\u3011\u4e0d\u80fd\u5927\u4e8e40\u4f4d")
    private @NotBlank(message="\u3010\u5546\u54c1\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=40, message="\u3010\u5546\u54c1\u540d\u79f0\u3011\u4e0d\u80fd\u5927\u4e8e40\u4f4d") String spuName;
    @NotBlank(message="\u3010\u54c1\u724c\u540d\u3011\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(max=20, message="\u3010\u54c1\u724c\u540d\u3011\u4e0d\u80fd\u5927\u4e8e20\u4f4d")
    private @NotBlank(message="\u3010\u54c1\u724c\u540d\u3011\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=20, message="\u3010\u54c1\u724c\u540d\u3011\u4e0d\u80fd\u5927\u4e8e20\u4f4d") String brandName;
    @NotNull(message="\u3010\u7c7b\u76eeid\u3011\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u3010\u7c7b\u76eeid\u3011\u4e0d\u80fd\u4e3a\u7a7a") Long categoryId;
    private Integer spuType;
    @NotBlank(message="\u3010\u5546\u54c1\u4e3b\u56fe\u3011\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u3010\u5546\u54c1\u4e3b\u56fe\u3011\u4e0d\u80fd\u4e3a\u7a7a") String mainImgs;
    @NotBlank(message="\u3010\u5546\u54c1\u8be6\u60c5\u56fe\u3011\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u3010\u5546\u54c1\u8be6\u60c5\u56fe\u3011\u4e0d\u80fd\u4e3a\u7a7a") String detailImgs;
    @NotNull(message="\u3010\u7a0e\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u3010\u7a0e\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a") Integer taxRate;
    @NotBlank(message="\u3010\u5546\u54c1\u63cf\u8ff0\u3011\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u3010\u5546\u54c1\u63cf\u8ff0\u3011\u4e0d\u80fd\u4e3a\u7a7a") String spuDesc;
    @NotNull(message="\u301069\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u301069\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a") String code69;
    private String credentialsImgs;
    private GoodsExpress goodsExpress;
    @NotEmpty(message="\u3010\u89c4\u683c\u660e\u7ec6\u3011\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotEmpty(message="\u3010\u89c4\u683c\u660e\u7ec6\u3011\u4e0d\u80fd\u4e3a\u7a7a") List<Sku> skus;

    public boolean isCreateOp() {
        return this.id == null;
    }

    public Integer getMinSupplyPrice() {
        if (CollectionUtils.isEmpty(this.skus)) {
            return null;
        }
        List supplyPriceList = this.skus.stream().map(Sku::getSupplyPrice).sorted().collect(Collectors.toList());
        return (Integer)supplyPriceList.get(0);
    }

    public Integer getMaxSupplyPrice() {
        if (CollectionUtils.isEmpty(this.skus)) {
            return null;
        }
        List supplyPriceList = this.skus.stream().map(Sku::getSupplyPrice).sorted().collect(Collectors.toList());
        return (Integer)supplyPriceList.get(supplyPriceList.size() - 1);
    }

    public Integer getMinMarketPrice() {
        if (CollectionUtils.isEmpty(this.skus)) {
            return null;
        }
        List marketPriceList = this.skus.stream().map(Sku::getMarketPrice).sorted().collect(Collectors.toList());
        return (Integer)marketPriceList.get(0);
    }

    public Integer getMaxMarketPrice() {
        if (CollectionUtils.isEmpty(this.skus)) {
            return null;
        }
        List marketPriceList = this.skus.stream().map(Sku::getMarketPrice).sorted().collect(Collectors.toList());
        return (Integer)marketPriceList.get(marketPriceList.size() - 1);
    }

    public Integer getMinSellPrice() {
        if (CollectionUtils.isEmpty(this.skus)) {
            return null;
        }
        List sellPriceList = this.skus.stream().map(Sku::getSellPrice).sorted().collect(Collectors.toList());
        return (Integer)sellPriceList.get(0);
    }

    public Integer getMaxSellPrice() {
        if (CollectionUtils.isEmpty(this.skus)) {
            return null;
        }
        List sellPriceList = this.skus.stream().map(Sku::getSellPrice).sorted().collect(Collectors.toList());
        return (Integer)sellPriceList.get(sellPriceList.size() - 1);
    }

    public String getCode69() {
        return this.code69;
    }

    public void setCode69(String code69) {
        this.code69 = code69;
    }

    public String getCredentialsImgs() {
        return this.credentialsImgs;
    }

    public void setCredentialsImgs(String credentialsImgs) {
        this.credentialsImgs = credentialsImgs;
    }

    public Long getSupplierId() {
        return this.supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Integer getSpuType() {
        return this.spuType;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public List<Sku> getSkus() {
        return this.skus;
    }

    public void setSkus(List<Sku> skus) {
        this.skus = skus;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSpuName() {
        return this.spuName;
    }

    public void setSpuName(String spuName) {
        this.spuName = spuName;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getMainImgs() {
        return this.mainImgs;
    }

    public void setMainImgs(String mainImgs) {
        this.mainImgs = mainImgs;
    }

    public String getDetailImgs() {
        return this.detailImgs;
    }

    public void setDetailImgs(String detailImgs) {
        this.detailImgs = detailImgs;
    }

    public Integer getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
    }

    public String getSpuDesc() {
        return this.spuDesc;
    }

    public void setSpuDesc(String spuDesc) {
        this.spuDesc = spuDesc;
    }

    public GoodsExpress getGoodsExpress() {
        return this.goodsExpress;
    }

    public void setGoodsExpress(GoodsExpress goodsExpress) {
        this.goodsExpress = goodsExpress;
    }

    public static class GoodsExpress
    implements Serializable {
        private static final long serialVersionUID = -2347079688489882828L;
        @NotBlank(message="\u3010\u53d1\u8d27\u5730\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        @Size(max=20, message="\u3010\u53d1\u8d27\u5730\u3011\u4e0d\u80fd\u5927\u4e8e20\u4f4d")
        private @NotBlank(message="\u3010\u53d1\u8d27\u5730\u3011\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=20, message="\u3010\u53d1\u8d27\u5730\u3011\u4e0d\u80fd\u5927\u4e8e20\u4f4d") String deliveryPlace;
        @NotBlank(message="\u3010\u53d1\u8d27\u7269\u6d41\u516c\u53f8\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        @Size(max=20, message="\u3010\u53d1\u8d27\u7269\u6d41\u516c\u53f8\u3011\u4e0d\u80fd\u5927\u4e8e20\u4f4d")
        private @NotBlank(message="\u3010\u53d1\u8d27\u7269\u6d41\u516c\u53f8\u3011\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=20, message="\u3010\u53d1\u8d27\u7269\u6d41\u516c\u53f8\u3011\u4e0d\u80fd\u5927\u4e8e20\u4f4d") String deliveryExpressCompany;
        @NotNull(message="\u3010\u662f\u5426\u652f\u6301\u4e03\u5929\u65e0\u7406\u7531\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        private @NotNull(message="\u3010\u662f\u5426\u652f\u6301\u4e03\u5929\u65e0\u7406\u7531\u3011\u4e0d\u80fd\u4e3a\u7a7a") Integer sevenDaysNoReason;
        @NotBlank(message="\u3010\u9000\u6362\u8d27\u5730\u5740\u4ee5\u53ca\u8054\u7cfb\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        @Size(max=150, message="\u3010\u9000\u6362\u8d27\u5730\u5740\u4ee5\u53ca\u8054\u7cfb\u65b9\u5f0f\u3011\u4e0d\u80fd\u5927\u4e8e150\u4f4d")
        private @NotBlank(message="\u3010\u9000\u6362\u8d27\u5730\u5740\u4ee5\u53ca\u8054\u7cfb\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=150, message="\u3010\u9000\u6362\u8d27\u5730\u5740\u4ee5\u53ca\u8054\u7cfb\u65b9\u5f0f\u3011\u4e0d\u80fd\u5927\u4e8e150\u4f4d") String details;

        public String getDeliveryPlace() {
            return this.deliveryPlace;
        }

        public void setDeliveryPlace(String deliveryPlace) {
            this.deliveryPlace = deliveryPlace;
        }

        public String getDeliveryExpressCompany() {
            return this.deliveryExpressCompany;
        }

        public void setDeliveryExpressCompany(String deliveryExpressCompany) {
            this.deliveryExpressCompany = deliveryExpressCompany;
        }

        public Integer getSevenDaysNoReason() {
            return this.sevenDaysNoReason;
        }

        public void setSevenDaysNoReason(Integer sevenDaysNoReason) {
            this.sevenDaysNoReason = sevenDaysNoReason;
        }

        public String getDetails() {
            return this.details;
        }

        public void setDetails(String details) {
            this.details = details;
        }
    }

    public static class Sku
    implements Serializable {
        private static final long serialVersionUID = -3074185137528877718L;
        public Long id;
        @NotBlank(message="\u3010\u89c4\u683c\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        @Size(max=20, message="\u3010\u89c4\u683c\u7f16\u7801\u3011\u4e0d\u80fd\u5927\u4e8e20\u4f4d")
        private @NotBlank(message="\u3010\u89c4\u683c\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a") @Size(max=20, message="\u3010\u89c4\u683c\u7f16\u7801\u3011\u4e0d\u80fd\u5927\u4e8e20\u4f4d") String supplierSkuCode;
        private String skuImg;
        @NotEmpty(message="\u3010\u89c4\u683c\u914d\u7f6e\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        private @NotEmpty(message="\u3010\u89c4\u683c\u914d\u7f6e\u3011\u4e0d\u80fd\u4e3a\u7a7a") List<AttrValue> attrValueList;
        @NotNull(message="\u3010\u4f9b\u8d27\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        private @NotNull(message="\u3010\u4f9b\u8d27\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a") Integer supplyPrice;
        @NotNull(message="\u3010\u5e02\u573a\u6307\u5bfc\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        private @NotNull(message="\u3010\u5e02\u573a\u6307\u5bfc\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a") Integer marketPrice;
        @NotNull(message="\u3010\u5efa\u8bae\u552e\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        private @NotNull(message="\u3010\u5efa\u8bae\u552e\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a") Integer sellPrice;
        @NotNull(message="\u3010\u4fee\u6539\u524d\u5e93\u5b58\u4f59\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        private @NotNull(message="\u3010\u4fee\u6539\u524d\u5e93\u5b58\u4f59\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a") Integer preRemaining;
        @NotNull(message="\u3010\u4fee\u6539\u540e\u5e93\u5b58\u4f59\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a")
        private @NotNull(message="\u3010\u4fee\u6539\u540e\u5e93\u5b58\u4f59\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a") Integer postRemaining;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getSupplierSkuCode() {
            return this.supplierSkuCode;
        }

        public void setSupplierSkuCode(String supplierSkuCode) {
            this.supplierSkuCode = supplierSkuCode;
        }

        public String getSkuImg() {
            return this.skuImg;
        }

        public void setSkuImg(String skuImg) {
            this.skuImg = skuImg;
        }

        public List<AttrValue> getAttrValueList() {
            return this.attrValueList;
        }

        public void setAttrValueList(List<AttrValue> attrValueList) {
            this.attrValueList = attrValueList;
        }

        public Integer getSupplyPrice() {
            return this.supplyPrice;
        }

        public void setSupplyPrice(Integer supplyPrice) {
            this.supplyPrice = supplyPrice;
        }

        public Integer getMarketPrice() {
            return this.marketPrice;
        }

        public void setMarketPrice(Integer marketPrice) {
            this.marketPrice = marketPrice;
        }

        public Integer getSellPrice() {
            return this.sellPrice;
        }

        public void setSellPrice(Integer sellPrice) {
            this.sellPrice = sellPrice;
        }

        public Integer getPreRemaining() {
            return this.preRemaining;
        }

        public void setPreRemaining(Integer preRemaining) {
            this.preRemaining = preRemaining;
        }

        public Integer getPostRemaining() {
            return this.postRemaining;
        }

        public void setPostRemaining(Integer postRemaining) {
            this.postRemaining = postRemaining;
        }
    }
}

