package cn.com.duiba.goods.inner.api.autoconfig.excel;

import cn.com.duiba.goods.common.exception.IllegalParamException;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.data.ReadCellData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * excel分析基础类
 * Created by guoyanfei .
 * 2022/12/26 .
 */
public class CommonAnalysisEventListener<T> extends AnalysisEventListener<T> {

    private static final Logger log = LoggerFactory.getLogger(CommonAnalysisEventListener.class);

    private Class<T> clazz;

    private List<T> dataList = new ArrayList<>();

    public CommonAnalysisEventListener(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void invoke(T data, AnalysisContext context) {
        dataList.add(data);
    }

    public List<T> getDataList() {
        return dataList;
    }

    @Override
    public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
        // 校验表头
        Field[] fields = this.clazz.getDeclaredFields();
        int size = 0;
        for (Field field : fields) {
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty == null) {
                continue;
            }
            int fieldHeadIndex = excelProperty.index();
            String fieldHeadName = excelProperty.value()[0];
            ReadCellData<?> currentHead = headMap.get(fieldHeadIndex);
            if (currentHead == null) {
                throw new IllegalParamException("文件格式错误1");
            }
            String currentHeadName = currentHead.getStringValue();

            if (!StringUtils.equals(fieldHeadName, currentHeadName)) {
                log.warn("上传的excel文件错误, fieldHeadName={}, currentHeadName={}", fieldHeadName, currentHeadName);
                throw new IllegalParamException("文件格式错误2");
            }
            size += 1;
        }
        if (size != headMap.size()) {
            log.warn("上传的excel文件错误, 期望列数={}, 实际列数={}", size, headMap.size());
            throw new IllegalParamException("文件格式错误3");
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        // do nothing
    }
}
