package cn.com.duiba.goods.inner.api.autoconfig.excel;

import com.alibaba.excel.EasyExcelFactory;
import org.apache.commons.collections4.CollectionUtils;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

/**
 * excel工具
 * Created by guoyanfei .
 * 2022/12/26 .
 */
public class EasyExcelComponent {

    public <T> List<T> readExcel(InputStream inputStream, Class<T> importParamClass) {
        CommonAnalysisEventListener listener = new CommonAnalysisEventListener(importParamClass);
        EasyExcelFactory.read(inputStream, importParamClass, listener).sheet().doRead();
        List<T> dataList = listener.getDataList();
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        return dataList;
    }

    public <T> void writeExcel(List<T> dataList, OutputStream outputStream, Class<T> outputParamClass) {
        EasyExcelFactory.write(outputStream, outputParamClass).autoCloseStream(true).sheet().doWrite(dataList);
    }
}
