package cn.com.duiba.goods.inner.api.dto;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 批量发货参数
 * Created by guoyanfei .
 * 2022/12/26 .
 */
public class BatchShipDTO implements Serializable {

    private static final long serialVersionUID = -1384621722779249368L;

    /**
     * 发货物流公司
     */
    @NotBlank(message = "【发货物流公司】不能为空")
    private String deliveryExpressCompany;

    /**
     * 物流单号
     */
    @NotBlank(message = "【物流单号】不能为空")
    private String trackingNumber;

    /**
     * 订单号
     */
    @NotBlank(message = "【订单号】不能为空")
    private String orderNo;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getDeliveryExpressCompany() {
        return deliveryExpressCompany;
    }

    public void setDeliveryExpressCompany(String deliveryExpressCompany) {
        this.deliveryExpressCompany = deliveryExpressCompany;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }
}
