package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.goods.common.enums.order.ShippedError;

import java.io.Serializable;

/**
 * 批量发货结果
 * Created by guoyanfei .
 * 2022/12/26 .
 */
public class BatchShipResultDTO implements Serializable {

    private static final long serialVersionUID = 435803737294610402L;

    /**
     * 批量发货参数
     */
    private BatchShipDTO dto;

    /**
     * 结果
     */
    private boolean success;

    /**
     * 额外信息
     */
    private String msg;

    public static BatchShipResultDTO success(BatchShipDTO dto) {
        return new BatchShipResultDTO(dto, true, null);
    }

    public static BatchShipResultDTO fail(BatchShipDTO dto, ShippedError error) {
        return new BatchShipResultDTO(dto, false, error.getDesc());
    }

    public BatchShipResultDTO() {
    }

    public BatchShipDTO getDto() {
        return dto;
    }

    public void setDto(BatchShipDTO dto) {
        this.dto = dto;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public BatchShipResultDTO(BatchShipDTO dto, boolean success, String msg) {
        this.dto = dto;
        this.success = success;
        this.msg = msg;
    }
}
