package cn.com.duiba.goods.inner.api.dto;

import java.io.Serializable;

public class Kuaidi100TrackDataDTO implements Serializable {

    private static final long serialVersionUID = -282042829720198553L;

    /**
     * 物流轨迹节点内容
     */
    private String context;

    /**
     * 时间，原始格式
     */
    private String time;

    /**
     * 格式化后时间
     */
    private String ftime;

    /**
     * 签收状态 (0在途，1揽收，2疑难，3签收，4退签，5派件，6退回，7转投)
     */
    private String status;

    /**
     * 本数据元对应的高级物流状态值，实时查询接口中提交resultv2=4标记后才会出现
     */
    private String statusCode;

    /**
     * 本数据元对应的行政区域的编码，实时查询接口中提交resultv2=1或者resultv2=4标记后才会出现
     */
    private String areaCode;

    /**
     * 本数据元对应的行政区域的名称，实时查询接口中提交resultv2=1或者resultv2=4标记后才会出现
     */
    private String areaName;

    /**
     * 本数据元对应的行政区域经纬度，实时查询接口中提交resultv2=4标记后才会出现
     */
    private String areaCenter;

    /**
     * 本数据元对应的快件当前地点，实时查询接口中提交resultv2=4标记后才会出现
     */
    private String location;

    /**
     * 本数据元对应的行政区域拼音，实时查询接口中提交resultv2=4标记后才会出现
     */
    private String areaPinYin;

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getFtime() {
        return ftime;
    }

    public void setFtime(String ftime) {
        this.ftime = ftime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getAreaCenter() {
        return areaCenter;
    }

    public void setAreaCenter(String areaCenter) {
        this.areaCenter = areaCenter;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getAreaPinYin() {
        return areaPinYin;
    }

    public void setAreaPinYin(String areaPinYin) {
        this.areaPinYin = areaPinYin;
    }
}
