package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.goods.common.enums.ExpressStateEnum;

import java.io.Serializable;
import java.util.List;

public class Kuaidi100TrackRespDTO implements Serializable {

    private static final long serialVersionUID = 1727890641308941474L;

    /**
     * 消息体，请忽略
     */
    private String message;

    /**
     * 快递单当前状态，默认为0在途，1揽收，2疑难，3签收，4退签，5派件，8清关，14拒签等10个基础物流状态，如需要返回高级物流状态，请参考 resultv2 传值
     * {@link ExpressStateEnum}
     */
    private String state;

    /**
     * 通讯状态，请忽略
     */
    private String status;

    /**
     * 快递单明细状态标记，暂未实现，请忽略
     */
    private String condition;

    /**
     * 是否签收标记，0未签收，1已签收，请忽略，明细状态请参考state字段
     */
    private String ischeck;

    /**
     * 快递公司编码,一律用小写字母
     */
    private String com;

    /**
     * 快递单号
     */
    private String nu;

    /**
     * 最新查询结果，数组，包含多项，全量，倒序（即时间最新的在最前），每项都是对象，对象包含字段请展开
     */
    private List<Kuaidi100TrackDataDTO> data;

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getNu() {
        return nu;
    }

    public void setNu(String nu) {
        this.nu = nu;
    }

    public String getIscheck() {
        return ischeck;
    }

    public void setIscheck(String ischeck) {
        this.ischeck = ischeck;
    }

    public String getCom() {
        return com;
    }

    public void setCom(String com) {
        this.com = com;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<Kuaidi100TrackDataDTO> getData() {
        return data;
    }

    public void setData(List<Kuaidi100TrackDataDTO> data) {
        this.data = data;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCondition() {
        return condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

}
