package cn.com.duiba.goods.inner.api.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 订单详情展示实体
 * Created by guoyanfei .
 * 2022/12/14 .
 */
public class OrderDetailDTO implements Serializable {

    private static final long serialVersionUID = -1132340275080616565L;

    /**
     * 订单状态
     * {@code @cn.com.duiba.goods.common.enums.order.OrderStatus}
     */
    private Integer orderStatus;

    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;

    /**
     * 客户id
     */
    private Long customerId;

    /**
     * 备注，买家留言
     */
    private String remark;

    /**
     * SPUid
     */
    private Long spuId;

    /**
     * 商品ID
     */
    private String spuCode;

    /**
     * SKUid
     */
    private Long skuId;

    /**
     * 兑吧的sku编码
     */
    private String skuCode;

    /**
     * 商品名称快照
     */
    private String snapshotSpuName;

    /**
     * 商品图片，sku图片>批量设置sku图>spu首图
     */
    private String snapshotGoodsImg;

    /**
     * 规格内容快照
     */
    private String snapshotAttrs;

    /**
     * 供货价快照，单位分，比如1元，数据存为100
     */
    private Integer snapshotSupplyPrice;

    /**
     * 商品数量
     */
    private Integer quantity;

    // --- 下方数据在其他表获取 ---

    /**
     * 物流相关信息
     */
    private OrderExpress orderExpress;

    /**
     * 客户名称（所属业务名称）
     */
    private String customerName;

    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 售后协商历史
     */
    private List<RefundOrder> refundOrders;

    /**
     * 售后订单状态，可能为空，为空就是无售后
     * {@code @cn.com.duiba.goods.common.enums.order.RefundOrderStatus}
     * CREATED(0, "等待审核"),
     * UNSHIPPED(1, "等待买家上传单号"),
     * SHIPPED(2, "买家退货待确认"),
     * COMPLETED(3, "已同意退款"),
     * REJECTED(4, "拒绝售后申请"),
     * CANCELED(5, "买家取消售后");
     */
    private Integer refundOrderStatus;

    public static class RefundOrder implements Serializable {

        private static final long serialVersionUID = -5752362642708215996L;

        /**
         * 操作名称
         */
        private String opName;

        /**
         * 时间
         */
        private Date gmtCreate;

        /**
         * 售后原因
         */
        private String refundReason;

        /**
         * 买家补充描述
         */
        private String buyerRemark;

        /**
         * 售后图片
         */
        private String refundImgs;

        /**
         * 买家手机号
         */
        private String buyerTel;

        /**
         * 售后订单号
         */
        private String refundOrderNo;

        /**
         * 售后订单状态变更记录
         */
        private List<StatusChangedRecord> statusChangedRecords;

        public static class StatusChangedRecord implements Serializable {

            private static final long serialVersionUID = -3827205919901203040L;

            /**
             * 时间
             */
            private Date gmtCreate;

            /**
             * 操作名称
             */
            private String opName;

            /**
             * 额外信息，比如：拒绝原因、物流单号
             */
            private String extInfo;

            public Date getGmtCreate() {
                return gmtCreate;
            }

            public void setGmtCreate(Date gmtCreate) {
                this.gmtCreate = gmtCreate;
            }

            public String getOpName() {
                return opName;
            }

            public void setOpName(String opName) {
                this.opName = opName;
            }

            public String getExtInfo() {
                return extInfo;
            }

            public void setExtInfo(String extInfo) {
                this.extInfo = extInfo;
            }
        }

        public String getOpName() {
            return opName;
        }

        public void setOpName(String opName) {
            this.opName = opName;
        }

        public Date getGmtCreate() {
            return gmtCreate;
        }

        public void setGmtCreate(Date gmtCreate) {
            this.gmtCreate = gmtCreate;
        }

        public String getRefundReason() {
            return refundReason;
        }

        public void setRefundReason(String refundReason) {
            this.refundReason = refundReason;
        }

        public String getBuyerRemark() {
            return buyerRemark;
        }

        public void setBuyerRemark(String buyerRemark) {
            this.buyerRemark = buyerRemark;
        }

        public String getRefundImgs() {
            return refundImgs;
        }

        public void setRefundImgs(String refundImgs) {
            this.refundImgs = refundImgs;
        }

        public String getBuyerTel() {
            return buyerTel;
        }

        public void setBuyerTel(String buyerTel) {
            this.buyerTel = buyerTel;
        }

        public String getRefundOrderNo() {
            return refundOrderNo;
        }

        public void setRefundOrderNo(String refundOrderNo) {
            this.refundOrderNo = refundOrderNo;
        }

        public List<StatusChangedRecord> getStatusChangedRecords() {
            return statusChangedRecords;
        }

        public void setStatusChangedRecords(List<StatusChangedRecord> statusChangedRecords) {
            this.statusChangedRecords = statusChangedRecords;
        }
    }

    public static class OrderExpress implements Serializable {

        private static final long serialVersionUID = -4352352349232712404L;

        /**
         * 买家姓名
         */
        private String buyerName;

        /**
         * 买家手机号
         */
        private String buyerTel;

        /**
         * 发货物流公司
         */
        private String deliveryExpressCompany;

        /**
         * 物流单号
         */
        private String trackingNumber;

        /**
         * 省
         */
        private String province;

        /**
         * 市
         */
        private String city;

        /**
         * 区（县）
         */
        private String district;

        /**
         * 街道（镇）
         */
        private String street;

        /**
         * 详细地址
         */
        private String addrDetail;

        public String getBuyerName() {
            return buyerName;
        }

        public void setBuyerName(String buyerName) {
            this.buyerName = buyerName;
        }

        public String getBuyerTel() {
            return buyerTel;
        }

        public void setBuyerTel(String buyerTel) {
            this.buyerTel = buyerTel;
        }

        public String getDeliveryExpressCompany() {
            return deliveryExpressCompany;
        }

        public void setDeliveryExpressCompany(String deliveryExpressCompany) {
            this.deliveryExpressCompany = deliveryExpressCompany;
        }

        public String getTrackingNumber() {
            return trackingNumber;
        }

        public void setTrackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
        }

        public String getProvince() {
            return province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getDistrict() {
            return district;
        }

        public void setDistrict(String district) {
            this.district = district;
        }

        public String getStreet() {
            return street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public String getAddrDetail() {
            return addrDetail;
        }

        public void setAddrDetail(String addrDetail) {
            this.addrDetail = addrDetail;
        }
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getSpuId() {
        return spuId;
    }

    public void setSpuId(Long spuId) {
        this.spuId = spuId;
    }

    public String getSpuCode() {
        return spuCode;
    }

    public void setSpuCode(String spuCode) {
        this.spuCode = spuCode;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSnapshotSpuName() {
        return snapshotSpuName;
    }

    public void setSnapshotSpuName(String snapshotSpuName) {
        this.snapshotSpuName = snapshotSpuName;
    }

    public String getSnapshotGoodsImg() {
        return snapshotGoodsImg;
    }

    public void setSnapshotGoodsImg(String snapshotGoodsImg) {
        this.snapshotGoodsImg = snapshotGoodsImg;
    }

    public String getSnapshotAttrs() {
        return snapshotAttrs;
    }

    public void setSnapshotAttrs(String snapshotAttrs) {
        this.snapshotAttrs = snapshotAttrs;
    }

    public Integer getSnapshotSupplyPrice() {
        return snapshotSupplyPrice;
    }

    public void setSnapshotSupplyPrice(Integer snapshotSupplyPrice) {
        this.snapshotSupplyPrice = snapshotSupplyPrice;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public OrderExpress getOrderExpress() {
        return orderExpress;
    }

    public void setOrderExpress(OrderExpress orderExpress) {
        this.orderExpress = orderExpress;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCancelReason() {
        return cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public List<RefundOrder> getRefundOrders() {
        return refundOrders;
    }

    public void setRefundOrders(List<RefundOrder> refundOrders) {
        this.refundOrders = refundOrders;
    }

    public Integer getRefundOrderStatus() {
        return refundOrderStatus;
    }

    public void setRefundOrderStatus(Integer refundOrderStatus) {
        this.refundOrderStatus = refundOrderStatus;
    }
}
