package cn.com.duiba.goods.inner.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 全部订单页展示实体
 * Created by guoyanfei .
 * 2022/12/14 .
 */
public class OrderListDTO implements Serializable {

    private static final long serialVersionUID = -6356060846575433567L;

    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * 下单时间
     */
    private Date gmtCreate;

    /**
     * 商品图片，sku图片>批量设置sku图>spu首图
     */
    private String snapshotGoodsImg;

    /**
     * 商品名称快照
     */
    private String snapshotSpuName;

    /**
     * 规格内容快照
     */
    private String snapshotAttrs;

    /**
     * 供货价快照，单位分，比如1元，数据存为100
     */
    private Integer snapshotSupplyPrice;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 订单状态
     * {@code @cn.com.duiba.goods.common.enums.order.OrderStatus}
     */
    private Integer orderStatus;

    /**
     * 售后订单状态
     * {@code @cn.com.duiba.goods.common.enums.order.RefundOrderStatus}
     */
    private Integer refundOrderStatus;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getSnapshotGoodsImg() {
        return snapshotGoodsImg;
    }

    public void setSnapshotGoodsImg(String snapshotGoodsImg) {
        this.snapshotGoodsImg = snapshotGoodsImg;
    }

    public String getSnapshotSpuName() {
        return snapshotSpuName;
    }

    public void setSnapshotSpuName(String snapshotSpuName) {
        this.snapshotSpuName = snapshotSpuName;
    }

    public String getSnapshotAttrs() {
        return snapshotAttrs;
    }

    public void setSnapshotAttrs(String snapshotAttrs) {
        this.snapshotAttrs = snapshotAttrs;
    }

    public Integer getSnapshotSupplyPrice() {
        return snapshotSupplyPrice;
    }

    public void setSnapshotSupplyPrice(Integer snapshotSupplyPrice) {
        this.snapshotSupplyPrice = snapshotSupplyPrice;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getRefundOrderStatus() {
        return refundOrderStatus;
    }

    public void setRefundOrderStatus(Integer refundOrderStatus) {
        this.refundOrderStatus = refundOrderStatus;
    }
}
