package cn.com.duiba.goods.inner.api.dto;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 订单发货包装实体
 * Created by guoyanfei .
 * 2022/12/19 .
 */
public class OrderShipDTO implements Serializable {

    private static final long serialVersionUID = 770165113201830878L;

    /**
     * 发货物流公司
     */
    @NotBlank(message = "【发货物流公司】不能为空")
    private String deliveryExpressCompany;

    /**
     * 物流单号
     */
    @NotBlank(message = "【物流单号】不能为空")
    private String trackingNumber;

    /**
     * 订单号
     */
    @NotBlank(message = "【订单号】不能为空")
    private String orderNo;

    /**
     * 供应商id
     */
    @NotBlank(message = "【供应商id】不能为空")
    private Long supplierId;

    public String getDeliveryExpressCompany() {
        return deliveryExpressCompany;
    }

    public void setDeliveryExpressCompany(String deliveryExpressCompany) {
        this.deliveryExpressCompany = deliveryExpressCompany;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
}
