package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.wolf.entity.PageRequest;

import javax.validation.constraints.NotNull;

/**
 * 售后订单分页筛选条件
 * Created by guoyanfei .
 * 2022/12/22 .
 */
public class RefundOrderListSearchDTO extends PageRequest {

    private static final long serialVersionUID = -6690897335789876179L;

    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * 售后订单号
     */
    private String refundOrderNo;

    /**
     * 供应商id
     */
    @NotNull(message = "【供应商id】不能为空")
    private Long supplierId;

    /**
     * 售后订单状态
     * {@code @cn.com.duiba.goods.common.enums.order.RefundOrderStatus}
     */
    private Integer refundOrderStatus;

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public Integer getRefundOrderStatus() {
        return refundOrderStatus;
    }

    public void setRefundOrderStatus(Integer refundOrderStatus) {
        this.refundOrderStatus = refundOrderStatus;
    }
}
