package cn.com.duiba.goods.inner.api.dto;

import java.io.Serializable;

/**
 * SPU列表展示用dto
 * Created by guoyanfei .
 * 2022/11/18 .
 */
public class SpuListDTO implements Serializable {

    private static final long serialVersionUID = 5599329193263342662L;

    /**
     * SPU id（不作为展示用）
     */
    private Long id;

    /**
     * 商品ID
     */
    private String spuCode;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 品牌名
     */
    private String brandName;

    /**
     * 商品类型，1实物，2虚拟
     * {@code @cn.com.duiba.goods.common.enums.goods.SpuType}
     */
    private Integer spuType;

    /**
     * 商品状态，1待提审，2审核中，3已入库
     * {@code @cn.com.duiba.goods.common.enums.goods.SpuState}
     */
    private Integer spuState;

    /**
     * 最低供货价，单位分，比如1元，此处数据为100
     */
    private Integer minSupplyPrice;

    /**
     * 最高供货价，单位分，比如1元，此处数据为100
     */
    private Integer maxSupplyPrice;

    /**
     * 最低指导价，单位分，比如1元，此处数据为100
     */
    private Integer minMarketPrice;

    /**
     * 最高指导价，单位分，比如1元，此处数据为100
     */
    private Integer maxMarketPrice;

    /**
     * 最低建议售价，单位分，比如1元，此处数据为100
     */
    private Integer minSellPrice;

    /**
     * 最高建议售价，单位分，比如1元，此处数据为100
     */
    private Integer maxSellPrice;

    // ====== 下方字段需要关联其他表获取 ======

    /**
     * 商品图
     */
    private String goodsImg;

    /**
     * 商品类目
     */
    private String categoryName;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 商品物流信息
     */
    private GoodsExpress goodsExpress;

    /**
     * 商品物流信息
     */
    public static class GoodsExpress implements Serializable {

        private static final long serialVersionUID = 7250675723900568591L;

        /**
         * 发货地
         */
        private String deliveryPlace;

        /**
         * 发货物流公司
         */
        private String deliveryExpressCompany;

        /**
         * 七天无理由，1支持，0不支持
         * {@code @cn.com.duiba.goods.common.enums.goods.SevenDaysNoReason}
         */
        private Integer sevenDaysNoReason;

        public String getDeliveryPlace() {
            return deliveryPlace;
        }

        public void setDeliveryPlace(String deliveryPlace) {
            this.deliveryPlace = deliveryPlace;
        }

        public String getDeliveryExpressCompany() {
            return deliveryExpressCompany;
        }

        public void setDeliveryExpressCompany(String deliveryExpressCompany) {
            this.deliveryExpressCompany = deliveryExpressCompany;
        }

        public Integer getSevenDaysNoReason() {
            return sevenDaysNoReason;
        }

        public void setSevenDaysNoReason(Integer sevenDaysNoReason) {
            this.sevenDaysNoReason = sevenDaysNoReason;
        }

    }

    public GoodsExpress getGoodsExpress() {
        return goodsExpress;
    }

    public void setGoodsExpress(GoodsExpress goodsExpress) {
        this.goodsExpress = goodsExpress;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSpuCode() {
        return spuCode;
    }

    public void setSpuCode(String spuCode) {
        this.spuCode = spuCode;
    }

    public String getSpuName() {
        return spuName;
    }

    public void setSpuName(String spuName) {
        this.spuName = spuName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Integer getSpuType() {
        return spuType;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public Integer getSpuState() {
        return spuState;
    }

    public void setSpuState(Integer spuState) {
        this.spuState = spuState;
    }

    public Integer getMinSupplyPrice() {
        return minSupplyPrice;
    }

    public void setMinSupplyPrice(Integer minSupplyPrice) {
        this.minSupplyPrice = minSupplyPrice;
    }

    public Integer getMaxSupplyPrice() {
        return maxSupplyPrice;
    }

    public void setMaxSupplyPrice(Integer maxSupplyPrice) {
        this.maxSupplyPrice = maxSupplyPrice;
    }

    public Integer getMinMarketPrice() {
        return minMarketPrice;
    }

    public void setMinMarketPrice(Integer minMarketPrice) {
        this.minMarketPrice = minMarketPrice;
    }

    public Integer getMaxMarketPrice() {
        return maxMarketPrice;
    }

    public void setMaxMarketPrice(Integer maxMarketPrice) {
        this.maxMarketPrice = maxMarketPrice;
    }

    public Integer getMinSellPrice() {
        return minSellPrice;
    }

    public void setMinSellPrice(Integer minSellPrice) {
        this.minSellPrice = minSellPrice;
    }

    public Integer getMaxSellPrice() {
        return maxSellPrice;
    }

    public void setMaxSellPrice(Integer maxSellPrice) {
        this.maxSellPrice = maxSellPrice;
    }

    public String getGoodsImg() {
        return goodsImg;
    }

    public void setGoodsImg(String goodsImg) {
        this.goodsImg = goodsImg;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
}
