package cn.com.duiba.goods.inner.api.dto;

import cn.com.duiba.goods.common.dto.AttrValue;

import java.io.Serializable;
import java.util.List;

/**
 * 单个SPU下面每个SKU的库存DTO
 */
public class SpuStockDTO implements Serializable {

    private static final long serialVersionUID = -4777481542446161675L;

    /**
     * SKU id
     */
    private Long skuId;

    /**
     * 规格配置
     */
    private List<AttrValue> attrValueList;

    /**
     * 供应商的规格编码
     */
    private String supplierSkuCode;

    /**
     * 库存余量
     */
    private Integer remaining;

    public Long getSkuId() {
        return skuId;
    }

    public List<AttrValue> getAttrValueList() {
        return attrValueList;
    }

    public void setAttrValueList(List<AttrValue> attrValueList) {
        this.attrValueList = attrValueList;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSupplierSkuCode() {
        return supplierSkuCode;
    }

    public void setSupplierSkuCode(String supplierSkuCode) {
        this.supplierSkuCode = supplierSkuCode;
    }

    public Integer getRemaining() {
        return remaining;
    }

    public void setRemaining(Integer remaining) {
        this.remaining = remaining;
    }
}
