package cn.com.duiba.goods.inner.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 待发货订单列表展示实体
 * Created by guoyanfei .
 * 2022/12/14 .
 */
public class UnshippedOrderListDTO implements Serializable {

    private static final long serialVersionUID = -8087175953337047375L;
    
    /**
     * 唯一订单号
     */
    private String orderNo;

    /**
     * 下单时间
     */
    private Date gmtCreate;

    /**
     * 商品图片，sku图片>批量设置sku图>spu首图
     */
    private String snapshotGoodsImg;

    /**
     * 商品名称快照
     */
    private String snapshotSpuName;

    /**
     * 规格内容快照
     */
    private String snapshotAttrs;

    /**
     * 供货价快照，单位分，比如1元，数据存为100
     */
    private Integer snapshotSupplyPrice;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 进入待发货时间
     */
    private Date unshippedGmtCreate;

    /**
     * 发货物流信息
     */
    private OrderExpress orderExpress;

    public static class OrderExpress implements Serializable {

        private static final long serialVersionUID = -1550555659938402689L;

        /**
         * 买家姓名
         */
        private String buyerName;

        /**
         * 买家手机号
         */
        private String buyerTel;

        /**
         * 发货物流公司
         */
        private String deliveryExpressCompany;

        /**
         * 物流单号
         */
        private String trackingNumber;

        /**
         * 省
         */
        private String province;

        /**
         * 市
         */
        private String city;

        /**
         * 区（县）
         */
        private String district;

        /**
         * 街道（镇）
         */
        private String street;

        /**
         * 详细地址
         */
        private String addrDetail;

        public String getBuyerName() {
            return buyerName;
        }

        public void setBuyerName(String buyerName) {
            this.buyerName = buyerName;
        }

        public String getBuyerTel() {
            return buyerTel;
        }

        public void setBuyerTel(String buyerTel) {
            this.buyerTel = buyerTel;
        }

        public String getDeliveryExpressCompany() {
            return deliveryExpressCompany;
        }

        public void setDeliveryExpressCompany(String deliveryExpressCompany) {
            this.deliveryExpressCompany = deliveryExpressCompany;
        }

        public String getTrackingNumber() {
            return trackingNumber;
        }

        public void setTrackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
        }

        public String getProvince() {
            return province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getDistrict() {
            return district;
        }

        public void setDistrict(String district) {
            this.district = district;
        }

        public String getStreet() {
            return street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public String getAddrDetail() {
            return addrDetail;
        }

        public void setAddrDetail(String addrDetail) {
            this.addrDetail = addrDetail;
        }
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getSnapshotGoodsImg() {
        return snapshotGoodsImg;
    }

    public void setSnapshotGoodsImg(String snapshotGoodsImg) {
        this.snapshotGoodsImg = snapshotGoodsImg;
    }

    public String getSnapshotSpuName() {
        return snapshotSpuName;
    }

    public void setSnapshotSpuName(String snapshotSpuName) {
        this.snapshotSpuName = snapshotSpuName;
    }

    public String getSnapshotAttrs() {
        return snapshotAttrs;
    }

    public void setSnapshotAttrs(String snapshotAttrs) {
        this.snapshotAttrs = snapshotAttrs;
    }

    public Integer getSnapshotSupplyPrice() {
        return snapshotSupplyPrice;
    }

    public void setSnapshotSupplyPrice(Integer snapshotSupplyPrice) {
        this.snapshotSupplyPrice = snapshotSupplyPrice;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Date getUnshippedGmtCreate() {
        return unshippedGmtCreate;
    }

    public void setUnshippedGmtCreate(Date unshippedGmtCreate) {
        this.unshippedGmtCreate = unshippedGmtCreate;
    }

    public OrderExpress getOrderExpress() {
        return orderExpress;
    }

    public void setOrderExpress(OrderExpress orderExpress) {
        this.orderExpress = orderExpress;
    }
}
