package cn.com.duiba.goods.inner.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.common.dto.ExpressCompany;
import cn.com.duiba.goods.inner.api.dto.*;
import cn.com.duiba.wolf.entity.PageRequest;
import cn.com.duiba.wolf.entity.PageResponse;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 售后订单相关服务
 * Created by guoyanfei .
 * 2022/12/19 .
 */
@AdvancedFeignClient
public interface RemoteUnshippedOrderService {

    /**
     * 订单发货
     *
     * @param dto
     */
    void ship(@Valid OrderShipDTO dto) throws BizException;

    /**
     * 分页查询
     *
     * @param dto
     * @return
     */
    PageResponse<UnshippedOrderListDTO> page(@Valid UnshippedOrderListSearchDTO dto);

    /**
     * 查询单条
     *
     * @param supplierId
     * @param orderNo
     * @return
     */
    UnshippedOrderDTO get(@NotNull(message = "【供应商id】不能为null") Long supplierId, @NotBlank(message = "【订单号】不能为空") String orderNo);

    /**
     * 查询数量
     *
     * @param supplierId
     * @return
     */
    Integer count(@NotNull(message = "【供应商id】不能为null") Long supplierId);

    /**
     * 分页查询批量发货记录
     *
     * @param supplierId
     * @param param
     * @return
     */
    PageResponse<BatchShippedRecordDTO> pageBatchShippedRecord(@NotNull(message = "【供应商id】不能为null") Long supplierId, PageRequest param);

    /**
     * 批量发货
     * @param supplierId
     * @param dtos
     * @return
     */
    List<BatchShipResultDTO> batchShip(@NotNull(message = "【供应商id】不能为null") Long supplierId, @Valid @NotEmpty(message = "【发货信息不能为空】") List<BatchShipDTO> dtos);

    /**
     * 保存批量发货记录
     * @param dto
     */
    void saveBatchShippedRecord(@Valid BatchShippedRecordSaveDTO dto);

    /**
     * 获取国内的快递公司
     * @return
     */
    List<ExpressCompany> getDomesticExpressCompanyList();

    /**
     * 根据订单，查物流信息
     * @param supplierId
     * @param orderNo
     * @return
     */
    Kuaidi100TrackRespDTO getTrack(@NotNull(message = "【供应商id】不能为null") Long supplierId, @NotBlank(message = "【订单号】不能为空") String orderNo) throws BizException;
}
