package cn.com.duiba.goods.open.api;

import cn.com.duiba.goods.open.api.constant.OpenApiConstant;
import cn.com.duiba.goods.open.api.support.OpenApiPermissionAspect;
import cn.com.duiba.goods.open.api.support.OpenApiPermissionContext;
import feign.RequestInterceptor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * 商品中心openapi自动配置
 * Created by guoyanfei .
 * 2022/11/8 .
 */
@EnableConfigurationProperties({ GoodsOpenApiProperties.class })
public class GoodsOpenApiAutoConfiguration {

    @Bean
    public OpenApiPermissionAspect openApiPermissionAspect() {
        return new OpenApiPermissionAspect();
    }

    @Bean
    public RequestInterceptor openApiRequestInterceptor(){
        return template -> {
            // 存在openapi鉴权用的上下文，就设置到header中
            OpenApiPermissionContext context = OpenApiPermissionContext.get();
            if (context != null) {
                template.header(OpenApiConstant.HEADER_API_KEY, context.getApiKey());
                template.header(OpenApiConstant.HEADER_TIMESTAMP, context.getTimestamp() + "");
                template.header(OpenApiConstant.HEADER_SIGN, context.getSign());
            }
        };
    }
}
