package cn.com.duiba.goods.open.api.support;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang3.StringUtils;

/**
 * 商品中心openapi调用权限上下文
 * Created by guoyanfei .
 * 2022/11/9 .
 */
public class OpenApiPermissionContext {

    private OpenApiPermissionContext() {
    }

    private String apiKey;

    private Long timestamp;

    private String sign;

    private static class TransmittableThreadLocalHolder {

        private TransmittableThreadLocalHolder() {
        }

        protected static final TransmittableThreadLocal<OpenApiPermissionContext> threadLocal2OpenApiPermission = new TransmittableThreadLocal<OpenApiPermissionContext>();
    }

    public static OpenApiPermissionContext get() {
        return TransmittableThreadLocalHolder.threadLocal2OpenApiPermission.get();
    }

    public static boolean isExisted() {
        return TransmittableThreadLocalHolder.threadLocal2OpenApiPermission.get() != null;
    }

    public static void set(String apiKey, Long timestamp, String sign) {
        if (StringUtils.isBlank(apiKey) || timestamp == null || StringUtils.isBlank(sign)) {
            throw new NullArgumentException("参数不全，无法设置权限参数");
        }
        OpenApiPermissionContext c = TransmittableThreadLocalHolder.threadLocal2OpenApiPermission.get();
        if (c == null) {
            c = new OpenApiPermissionContext();
        }
        c.apiKey = apiKey;
        c.timestamp = timestamp;
        c.sign = sign;
        TransmittableThreadLocalHolder.threadLocal2OpenApiPermission.set(c);
    }

    public static void remove() {
        TransmittableThreadLocalHolder.threadLocal2OpenApiPermission.remove();
    }

    public String getApiKey() {
        return apiKey;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public String getSign() {
        return sign;
    }
}
