package cn.com.duiba.goods.open.api.utils;

import cn.com.duiba.goods.open.api.constant.OpenApiConstant;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.*;

/**
 * 签名工具类
 */
public class SignTool {

    /**
     * 验证签名
     *
     * @param secret
     * @param params
     * @return
     */
    public static boolean signVerify(String apiSecret, Map<String, String> params) {
        Map<String, String> map = new HashMap<>();
        map.put(OpenApiConstant.API_SECRET, apiSecret);
        for (String key : params.keySet()) {
            if (!key.equals(OpenApiConstant.SIGN)) {
                map.put(key, params.get(key));
            }
        }
        String sign = sign(map);
        return sign.equals(params.get(OpenApiConstant.SIGN));
    }

    /**
     * 签名
     *
     * @param params
     * @return
     */
    public static String sign(Map<String, String> params) {
        List<String> keys = new ArrayList<>(params.keySet());
        Collections.sort(keys);
        StringBuilder string = new StringBuilder();
        for (String s : keys) {
            string.append(params.get(s));
        }
        String sign;
        try {
            sign = toHexValue(encryptMD5(string.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            throw new RuntimeException("md5 error");
        }
        return sign;
    }

    private static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    private static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) return "";
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

}
