/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.open.api.support;

import cn.com.duiba.goods.open.api.GoodsOpenApiProperties;
import cn.com.duiba.goods.open.api.exception.NoPermissionException;
import cn.com.duiba.goods.open.api.support.OpenApiPermissionContext;
import cn.com.duiba.goods.open.api.utils.SignTool;
import java.util.HashMap;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class OpenApiPermissionAspect {
    @Resource
    private GoodsOpenApiProperties goodsOpenApiProperties;

    @Pointcut(value="execution(public * cn.com.duiba.goods.open.api.remoteservice..*.*(..))")
    private void remoteCallOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="remoteCallOperation()")
    public Object makePermission(ProceedingJoinPoint point) throws Throwable {
        if (!point.getSignature().getDeclaringType().isInterface()) {
            return point.proceed();
        }
        try {
            if (this.goodsOpenApiProperties.isConfigExisted()) {
                long timestamp = System.currentTimeMillis();
                String sign = this.sign(timestamp);
                OpenApiPermissionContext.set(this.goodsOpenApiProperties.getApiKey(), timestamp, sign);
            }
            if (!OpenApiPermissionContext.isExisted()) {
                throw new NoPermissionException("\u65e0\u6743\u8bbf\u95ee");
            }
            Object object = point.proceed();
            return object;
        }
        finally {
            OpenApiPermissionContext.remove();
        }
    }

    private String sign(long timestamp) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("apiKey", this.goodsOpenApiProperties.getApiKey());
        params.put("apiSecret", this.goodsOpenApiProperties.getApiSecret());
        params.put("timestamp", timestamp + "");
        return SignTool.sign(params);
    }
}

