package cn.com.duiba.goods.open.api;

import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 商品openapi鉴权配置
 * Created by guoyanfei .
 * 2022/11/8 .
 */
@ConfigurationProperties(prefix = "duiba.goods.open.api")
public class GoodsOpenApiProperties {

    private String apiKey;

    private String apiSecret;

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiSecret() {
        return apiSecret;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public boolean isConfigExisted() {
        return StringUtils.isNotBlank(apiKey) && StringUtils.isNotBlank(apiSecret);
    }

}
