package cn.com.duiba.goods.open.api.constant;

/**
 * 对外事件类型
 * Created by guoyanfei .
 * 2022/12/20 .
 */
public enum OpenEventType {

    /**
     * 商品变更
     */
    GOODS_CHANGED("GoodsChanged"),

    /**
     * 订单发货发出
     */
    ORDER_SHIPPED("OrderShipped"),

    /**
     * 同意售后
     */
    REFUND_ACCEPTED("RefundAccepted"),

    /**
     * 拒绝售后
     */
    REFUND_REJECTED("RefundRejected"),

    /**
     * 供应商确认收货
     */
    REFUND_SUPPLIER_CONFIRM_RECEIPT("RefundSupplierConfirmReceipt");

    private final String type;

    OpenEventType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }
}
