package cn.com.duiba.goods.open.api.dto;

import cn.com.duiba.goods.common.dto.AttrValue;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 商品信息
 * Created by guoyanfei .
 * 2022/12/13 .
 */
public class GoodsOpenDTO implements Serializable {

    private static final long serialVersionUID = 1691549699835152091L;

    /**
     * 商品ID
     */
    private String spuCode;

    /**
     * 商品名称
     */
    private String spuName;

    /**
     * 品牌名
     */
    private String brandName;

    /**
     * 商品类型，1实物，2虚拟
     * {@code @cn.com.duiba.goods.common.enums.goods.SpuType}
     */
    private Integer spuType;

    /**
     * 商品主图链接，多张图用英文 逗号 分割
     */
    private String mainImgs;

    /**
     * 商品详情图链接，多张图用英文 逗号 分割
     */
    private String detailImgs;

    /**
     * 税率，比如16%，那么存储1600
     */
    private Integer taxRate;

    /**
     * 商品描述
     */
    private String spuDesc;

    /**
     * 69码
     */
    private String code69;

    /**
     * 商品资质图
     */
    private String credentialsImgs;

    /**
     * 排序时间，默认值为创建时间，在审核入库操作后更新为入库时间
     * 用于商品库展示的时候按照这个时间倒排，可以实现新审核入库的展示在前面
     * 如果按照创建时间倒排，新审核入库的不一定在最前面
     */
    private Date sortTime;

    // ====== 下方字段需要关联其他表获取 ======

    /**
     * 商品类目
     */
    private String categoryName;

    /**
     * sku列表
     */
    private List<Sku> skus;

    /**
     * 商品物流信息
     */
    private GoodsExpress goodsExpress;

    /**
     * 商品详情(SKU)展示实体
     */
    public static class Sku implements Serializable {

        private static final long serialVersionUID = -8315260847199005169L;

        /**
         * 兑吧的sku编码，全局唯一（暂时不用于展示）
         */
        private String skuCode;

        /**
         * 供应商的规格编码
         */
        private String supplierSkuCode;

        /**
         * SKU图，这个图是详情展示图，逻辑为 SKU图 -> 批量SKU图 -> 商品主图
         */
        private String showSkuImg;

        /**
         * 优先级最高的SKU图，是针对单个SKU单独设置的
         */
        private String skuImg;

        /**
         * 规格配置
         */
        private List<AttrValue> attrValueList;

        /**
         * 指导价，划线价，单位分，比如1元，数据存为100
         */
        private Integer marketPrice;

        /**
         * 售价，平台卖价，单位分，比如1元，数据存为100
         */
        private Integer sellPrice;

        /**
         * 库存余量
         */
        private Integer remaining;

        public String getSkuCode() {
            return skuCode;
        }

        public void setSkuCode(String skuCode) {
            this.skuCode = skuCode;
        }

        public String getSupplierSkuCode() {
            return supplierSkuCode;
        }

        public void setSupplierSkuCode(String supplierSkuCode) {
            this.supplierSkuCode = supplierSkuCode;
        }

        public String getShowSkuImg() {
            return showSkuImg;
        }

        public void setShowSkuImg(String showSkuImg) {
            this.showSkuImg = showSkuImg;
        }

        public String getSkuImg() {
            return skuImg;
        }

        public void setSkuImg(String skuImg) {
            this.skuImg = skuImg;
        }

        public List<AttrValue> getAttrValueList() {
            return attrValueList;
        }

        public void setAttrValueList(List<AttrValue> attrValueList) {
            this.attrValueList = attrValueList;
        }

        public Integer getMarketPrice() {
            return marketPrice;
        }

        public void setMarketPrice(Integer marketPrice) {
            this.marketPrice = marketPrice;
        }

        public Integer getSellPrice() {
            return sellPrice;
        }

        public void setSellPrice(Integer sellPrice) {
            this.sellPrice = sellPrice;
        }

        public Integer getRemaining() {
            return remaining;
        }

        public void setRemaining(Integer remaining) {
            this.remaining = remaining;
        }
    }

    /**
     * 商品物流信息
     */
    public static class GoodsExpress implements Serializable {

        private static final long serialVersionUID = -2711936634454570415L;

        /**
         * 发货地
         */
        private String deliveryPlace;

        /**
         * 发货物流公司
         */
        private String deliveryExpressCompany;

        /**
         * 七天无理由，1支持，0不支持
         * {@code @cn.com.duiba.goods.common.enums.goods.SevenDaysNoReason}
         */
        private Integer sevenDaysNoReason;

        /**
         * 退换货地址以及联系方式
         */
        private String details;

        public String getDeliveryPlace() {
            return deliveryPlace;
        }

        public void setDeliveryPlace(String deliveryPlace) {
            this.deliveryPlace = deliveryPlace;
        }

        public String getDeliveryExpressCompany() {
            return deliveryExpressCompany;
        }

        public void setDeliveryExpressCompany(String deliveryExpressCompany) {
            this.deliveryExpressCompany = deliveryExpressCompany;
        }

        public Integer getSevenDaysNoReason() {
            return sevenDaysNoReason;
        }

        public void setSevenDaysNoReason(Integer sevenDaysNoReason) {
            this.sevenDaysNoReason = sevenDaysNoReason;
        }

        public String getDetails() {
            return details;
        }

        public void setDetails(String details) {
            this.details = details;
        }
    }

    public String getSpuCode() {
        return spuCode;
    }

    public void setSpuCode(String spuCode) {
        this.spuCode = spuCode;
    }

    public String getSpuName() {
        return spuName;
    }

    public void setSpuName(String spuName) {
        this.spuName = spuName;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Integer getSpuType() {
        return spuType;
    }

    public void setSpuType(Integer spuType) {
        this.spuType = spuType;
    }

    public String getMainImgs() {
        return mainImgs;
    }

    public void setMainImgs(String mainImgs) {
        this.mainImgs = mainImgs;
    }

    public String getDetailImgs() {
        return detailImgs;
    }

    public void setDetailImgs(String detailImgs) {
        this.detailImgs = detailImgs;
    }

    public Integer getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
    }

    public String getSpuDesc() {
        return spuDesc;
    }

    public void setSpuDesc(String spuDesc) {
        this.spuDesc = spuDesc;
    }

    public String getCode69() {
        return code69;
    }

    public void setCode69(String code69) {
        this.code69 = code69;
    }

    public String getCredentialsImgs() {
        return credentialsImgs;
    }

    public void setCredentialsImgs(String credentialsImgs) {
        this.credentialsImgs = credentialsImgs;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public List<Sku> getSkus() {
        return skus;
    }

    public void setSkus(List<Sku> skus) {
        this.skus = skus;
    }

    public GoodsExpress getGoodsExpress() {
        return goodsExpress;
    }

    public Date getSortTime() {
        return sortTime;
    }

    public void setSortTime(Date sortTime) {
        this.sortTime = sortTime;
    }

    public void setGoodsExpress(GoodsExpress goodsExpress) {
        this.goodsExpress = goodsExpress;
    }
}
