package cn.com.duiba.goods.open.api.dto;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 买家发退货请求参数
 * Created by guoyanfei .
 * 2022/12/13 .
 */
public class GoodsReturnDTO implements Serializable {

    private static final long serialVersionUID = -1319869944879339879L;

    /**
     * 售后订单号
     */
    @NotBlank(message = "【售后订单号】不能为空")
    private String refundOrderNo;

    /**
     * 退货物流单号
     */
    @NotBlank(message = "【退货物流单号】不能为空")
    private String trackingNumber;

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public String getTrackingNumber() {
        return trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }
}
