package cn.com.duiba.goods.open.api.dto;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 实物下单请求参数
 * Created by guoyanfei .
 * 2022/12/13 .
 */
public class ObjectOrderCreateDTO implements Serializable {

    private static final long serialVersionUID = -1199178103288435537L;

    /**
     * SKU code
     */
    @NotBlank(message = "【skuCode】不能为空")
    private String skuCode;

    /**
     * 商品数量
     */
    @NotNull(message = "【商品数量】不能为空")
    private Integer quantity = 1;

    /**
     * 客户订单号
     */
    @NotBlank(message = "【订单号】不能为空")
    private String customerOrderNo;

    /**
     * 备注，买家留言
     */
    private String remark;

    /**
     * 订单物流信息
     */
    @NotBlank(message = "【订单物流信息】不能为空")
    private OrderExpress orderExpress;

    /**
     * 订单是否已经确认完毕。默认为确认完毕（不需要确认）
     * 比如需要审核的订单，那么设置该字段为false
     */
    private boolean confirmed = true;

    public static class OrderExpress implements Serializable {

        private static final long serialVersionUID = 8419541196030399579L;

        /**
         * 买家姓名
         */
        private String buyerName;

        /**
         * 买家手机号
         */
        private String buyerTel;

        /**
         * 省
         */
        private String province;

        /**
         * 市
         */
        private String city;

        /**
         * 区（县）
         */
        private String district;

        /**
         * 街道（镇）
         */
        private String street;

        /**
         * 详细地址
         */
        private String addrDetail;

        public String getBuyerName() {
            return buyerName;
        }

        public void setBuyerName(String buyerName) {
            this.buyerName = buyerName;
        }

        public String getBuyerTel() {
            return buyerTel;
        }

        public void setBuyerTel(String buyerTel) {
            this.buyerTel = buyerTel;
        }

        public String getProvince() {
            return province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String getCity() {
            return city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getDistrict() {
            return district;
        }

        public void setDistrict(String district) {
            this.district = district;
        }

        public String getStreet() {
            return street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public String getAddrDetail() {
            return addrDetail;
        }

        public void setAddrDetail(String addrDetail) {
            this.addrDetail = addrDetail;
        }
    }

    public boolean isConfirmed() {
        return confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public OrderExpress getOrderExpress() {
        return orderExpress;
    }

    public void setOrderExpress(OrderExpress orderExpress) {
        this.orderExpress = orderExpress;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getCustomerOrderNo() {
        return customerOrderNo;
    }

    public void setCustomerOrderNo(String customerOrderNo) {
        this.customerOrderNo = customerOrderNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
