package cn.com.duiba.goods.open.api.dto;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 订单取消请求参数
 * Created by guoyanfei .
 * 2022/12/19 .
 */
public class OrderCancelDTO implements Serializable {

    private static final long serialVersionUID = -6437012887422646982L;

    /**
     * 订单号
     */
    @NotNull(message = "【订单号】不能为空")
    private String orderNo;

    /**
     * 备注，比如取消原因
     */
    private String remark;

    public OrderCancelDTO() {
    }

    public OrderCancelDTO(String orderNo, String remark) {
        this.orderNo = orderNo;
        this.remark = remark;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
