package cn.com.duiba.goods.open.api.dto;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 订单完成请求参数
 * Created by guoyanfei .
 * 2022/12/19 .
 */
public class OrderCompleteDTO implements Serializable {

    private static final long serialVersionUID = 2179240426697262314L;

    /**
     * 订单号
     */
    @NotNull(message = "【订单号】不能为空")
    private String orderNo;

    /**
     * 备注
     */
    private String remark;

    public OrderCompleteDTO() {
    }

    public OrderCompleteDTO(String orderNo, String remark) {
        this.orderNo = orderNo;
        this.remark = remark;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
